{
    Flight Drone Display Controller
    (c) 2007 Perry James Mole
    pjm@ridge-communications.ca
    not for commercial use
                       
}
CON
  _CLKMODE = XTAL1 + PLL16X
  _XINFREQ = 5_000_000
  _stack = 48
   
  x_tiles = 16
  y_tiles = 12

VAR
  long seconds,minutes,ap,scale
  long map_xav[8],map_yav[8],xav[8],yav[8],elev[8]  ' moving average values

  long xao,yao,xa,ya,xo,yo,alto      ' inital offsets for zero/home reference
  
  long dx,dy,xd,yd,xb,yb,xs,ys,altitude,speed,heading,distance_to_home
  long meters_per_latitude,meters_per_longitude   ' active running varaibles
  
  long DecimalIndex,spacing,DecimalFlag,Digit,TempNum  ' place some temporay variables here
  long sign,ang,ptr,prop_lat ,prop_rad                 ' to save stack space

  long PAL_Mode      '  these two
  long bitmap[3072]  '  must be contiguous
  
  long display[3072] ' area for graphics engine to create next display bitmap
  
OBJ
    Clock      :   "Clock_mini"     ' take out stuf we dont't use 
    gps        :   "GPS_IO_mini"                                      
    TriXaccel  :   "MCP3208_mini"   ' take out stuf we dont't use (i.e. stop)
    overlay    :   "HITT_Video_Overlay_017"  ' must have active video input with mini
    gr         :   "graphics_mini"
    
PUB drone

overlay.start(@PAL_Mode)  ' start and setup overlay video     
    
gr.start                    ' start and setup graphics engine
gr.setup(x_tiles, y_tiles, 128, 96, @display)
gr.textmode(1,1,8,0)

gps.start                   ' start  GPS

TriXaccel.start(2,1,0,7)    ' start and setup accelerometers
                            ' we actually only use two of three
                            ' but one might want to mount the PCB vertically 
  
seconds := 500              ' initalize tenth's of seconds elapsed timer
minutes := -1               ' start at 0 minus 10 seconds 

xo := yo := xao := yao := alto := ap := 0   ' moving average rolling pointer

Clock.Init(_XINFREQ)        ' set up clock for accuate 10/second
Clock.SetClock(_CLKMODE)    ' video update rate
Clock.MarkSync
                 
Clock.WaitSyncMSec(2000)          ' wait one second for gps to get some data
 
repeat                            ' loop until death
  gr.colorwidth(1, 0)             ' Set Color and Width 
  gr.clear                        ' clear graphics for next display update

  SimpleNum(76,-95,minutes,-1)    ' display elapsed time       
  if seconds < 100
    gr.text(84, -95,string(".0"))
  else
    gr.text(84, -95,string("."))      
  SimpleNum(116,-95,seconds,1)
  
  gr.text(-127,-8,gps.satellites) ' display number of satellites in view
  gr.finish
  gr.text(-127,-20,gps.hdop)      ' display horizontal dilution of precision
  gr.text(-50, -95,gps.time)      ' display GMT time
  gr.text(-118,-95,gps.date)      ' display date
  gr.finish
   
  if minutes == 0                ' we hit countdown to zero 
        if seconds == 0          ' so use first 100 values for inital offsets 
           xo   := xo / 100      ' longitude
           yo   := yo / 100      ' latitude 
           xao  := xao / 100     ' roll
           yao  := yao / 100     ' pitch
           alto := alto / 100    ' altitude
           
  if minutes < 0
        set_meters_per_degree
        SimpleNum(6,-36,meters_per_latitude,-1)      ' just testing 
        SimpleNum(6,-48,meters_per_longitude,-1)     ' just testing
        xao +=  TriXaccel.in(0)         ' get data for initial offsets 
        yao +=  TriXaccel.in(1)         ' when elapsed timer
        yo += get_latitude              ' is less than zero 
        xo += get_longitude
        alto += atoi(gps.altitude,4)        
  else
                                         ' off we go ..... elapsed timer is positive
        xav[ap] := TriXaccel.in(0) - xao ' get data for moving averages 
        yav[ap] := TriXaccel.in(1) - yao        
        map_yav[ap] := get_latitude - yo
        map_xav[ap] := get_longitude - xo
        elev[ap] := atoi(gps.altitude,4)' - alto
        xd := yd := xa := ya := altitude := 0
        repeat dx from 0 to 7            ' sum moving averages
           xd  += map_xav[dx]
           yd  += map_yav[dx]
           xa  += xav[dx]
           ya  += yav[dx]
           altitude += elev[dx]
         
        xd  := xd/8                     ' average moving averages
        yd  := yd/8
        xa  := xa/8
        ya  := ya/8
        altitude := altitude/8 - alto
        ap  := (ap + 1) & $7             ' increment moving average rolling pointer

        if byte[gps.N_S] == "N"          ' fix up for hemisphere
           yd := -yd
           
        if byte[gps.E_W] == "W"          ' fix up for relationship to prime meridian 
           xd := -xd
                                 
        if atoi(gps.satellites,2) > 2
'           gr.text(96,-8,gps.vdop)         ' display vertical dilution of precision
           gr.text(-42, -82,gps.longitude) ' display Longitude
           gr.text( 42, -82,gps.E_W)
           gr.text(-34, -70,gps.latitude)  ' display Latitude
           gr.text( 42, -70,gps.N_S)
           
           meter(127,40,-altitude,2048)      ' display altitude  use - for right side of siaplay
           SimpleNum(118,34,altitude,-1)
           
           distance_to_home := ^^((xd*xd)+(yd*yd))
           SimpleNum(6,-58,distance_to_home,-1)   '  Display Distance to Home

           speed := atoi(gps.speed,4)             '  get  speed   from GPS
           speed := (speed * 1852) / 1000         '  Convert knots to km/hour  or ...
'           speed := (speed * 6076) / 5280         '  Convert knots to miles/hour                               
           meter(-128,40,speed,6144)
           SimpleNum(-110,34,speed,-1)
        
           heading :=  atoi(gps.heading,3)            '  get  heading from GPS 
           compass_dial(96,-50,(heading * 1024)/45)   '  Draw compass 
           SimpleNum(104,-20,heading,-1)              '  Display Compass Heading

           scale := 5                    
           if distance_to_home > 499                   ' zoom out ?  
              scale := 50                          
           if seconds // 2                               ' make these flash
              gr.colorwidth(1, 1)                        ' and larger
              gr.arc(xd/scale, -yd/scale,2, 2, 0, 23, 360, 0)   '  Display  spot relative to Home 
              if distance_to_home > 49                          '  Display pointer to Home
                 xs := ( 36 * xd ) / distance_to_home          
                 ys := ( 36 * yd ) / distance_to_home           ' no need for arcsine here !
                 gr.plot(96,-50)
                 gr.line(-xs+96,ys-50)
                              
        gr.colorwidth(1, 0)
                                            
        dial(-96,-50)                            '  Display artificial horizon             
        dx := xa / 5 ' 7                     
        dy := ya
        ang := (dy * 7) / 2

        repeat heading from -4096 to 0 step 512     '  Draw ground
             gr.arc(-96, -dx-50, 31, 31, ang+heading, 0 , 1, 3)
             
        repeat dy from -12 to 12 step 6           ' Put in pitch/roll reference lines
           gr.plot(dy-96,-50-dy/2)
           gr.line(dy-96,-50+dy/2)
           
        gr.arc(0, -3, 11, 11, -ang, 0, 1, 0)     '  Draw plane  wings
        gr.arc(0, -3, 11, 11, -ang+4096, 0, 1, 1)
       
        gr.arc(0, 3, 3, 3, -ang, 0, 1, 0)        '  Draw plane  tail wings
        gr.arc(0, 3, 3, 3, -ang+4096, 0, 1, 1)
           
        gr.arc(0, 4, 2, 2, -ang+2048, 0, 1, 0)   '  Draw tail  fin
        gr.arc(0, 0, 3, 3, -ang+6144, 0, 1, 1)

  seconds++                                      ' Update elasped Time 
  if seconds > 599
     seconds := 0
     minutes++
     
  gr.finish 
  gr.copy(@bitmap)         ' show the world what we have done
  Clock.WaitSyncMSec(100)  ' wait for 1/10 second and then keep on going

PUB set_meters_per_degree  ' figure  out local values for ellipsoid
    prop_lat :=  atoi(gps.latitude,2)
    prop_rad := (prop_lat * 1024)/45   ' prop angle just as good as radians ?
                      
    meters_per_latitude := -5598 * (cos(2*prop_rad)*1000/65536 ) 
    meters_per_latitude := 111133 + meters_per_latitude / 10000   ' use only two terms ellipsoid  
     
    meters_per_longitude := (-935 * cos(3*prop_rad)*1000/65536) / 10000
    prop_lat :=  cos(prop_rad)*10000/65536
    meters_per_longitude += (111413 * prop_lat) / 10000           ' use only two terms ellipsoid

    yb := atoi(gps.latitude, 2)     ' chose offsets
    if yb > 2                        ' for y base
       yb := yb - 2
    xb := atoi(gps.longitude,3) - 2  ' so we don't go over size of long integer
    if xb > 2                         ' and x base
       xb := xb - 2
       
PUB get_latitude
    result := to_meters(atoi(gps.latitude,2),atoi(gps.latitude+2, 2),atoi(gps.latitude+5,4),meters_per_latitude,yb)
    return  result
         
PUB get_longitude
    result := to_meters(atoi(gps.longitude,3),atoi(gps.longitude+3, 2),atoi(gps.longitude+6,4),meters_per_longitude,xb)
    return  result

PUB to_meters(deg,minu,sec,ellipsoid,offset)
    result := (deg - offset) * ellipsoid
    result += (minu * ellipsoid) / 60 
    result += (sec * ellipsoid) / 600000
    return result
              
PUB meter(x,y,a,s)    ' display left or right half of meter
    if a == 2048
     a := -a
    a := a * 19
    pointer(x,y,a)
    a++
    ticks(x,y,a)
    gr.arc(x, y, 31, 31, s, 31, 180, 0)
    
PUB pointer(x,y,a) 
    gr.arc(x, y, 25, 25, a+2048, 0, 1, 0)     ' Draw Pointer
    gr.arc(x, y, 25, 25, a+6144, 0, 1, 1)
        
PUB ticks(x,y,a) | dxx
    repeat dxx from 0 to 32                    ' Draw 32 ticks 
        gr.arc(x, y, 27, 27, dxx*256+a, 0, 1, 0)
        gr.arc(x, y, 30, 30, dxx*256+a, 0, 1, 1)

PUB compass_dial(x,y,a)
     dial(x,y)
     gr.text(x,    y+12, string("N"))              '  Spell the NEWS
     gr.text(x+19, y-9,  string("E"))
     gr.text(x-22, y-9,  string("W"))
     gr.text(x,    y-26, string("S"))           
     gr.colorwidth(1, 1)
     gr.arc(x, y, 25, 25, -a+2048, 0, 1, 0)        '  Draw needle
     gr.arc(x, y, 25, 25, -a+6144, 0, 1, 1)
     gr.arc(x, y,  2,  2, -a,      0, 1, 0)        '  Draw needle cross
     gr.arc(x, y,  2,  2, -a+4096, 0, 1, 1)
     gr.colorwidth(1, 1)
     gr.arc(x, y, 12, 12, -a+2048-400, 0, 1, 0) '  Draw needle arrow
     gr.arc(x, y, 28, 28, -a+2048, 0, 1, 1)      
     gr.arc(x, y, 12, 12, -a+2048+400, 0, 1, 1)
     gr.colorwidth(1, 0)
     
PUB dial(x,y) | dxx           ' display a full circle                  
     ticks(x,y,0)
     gr.arc(x, y, 30, 30, 0, 23, 360, 0)        
                
PUB atoi( pptr,c)| ptrr    ' convert c characters into number
  result := sign := 0
  if byte[pptr] == "-"
      sign++
      pptr++
  c--    
  repeat ptrr from 0 to c
    if byte[pptr+ptrr] == 0    ' stop if null
         quit
         
    if byte[pptr+ptrr] == "."  ' stop if decimal point
         quit
    else     
       result := result * 10 + (byte[pptr+ptrr] - "0")
  if sign == 1
    result := -result
          
PUB SimpleNum(x,y,DecimalNumber,DecimalPoint)           ' hacked up from propeller example
    DecimalIndex := DecimalFlag := 0

    TempNum := DecimalNumber                            ' Preserve sign of DecimalNumber
    DecimalNumber := ||DecimalNumber
    
    if DecimalNumber <> TempNum 
       sign := 1
    else
       sign := 0

    repeat                                             ' Print digits
      if DecimalPoint > 0
        if DecimalIndex == DecimalPoint
          gr.text(x,y,@DP)                              ' Insert decimal point at proper location
          x -= 8

      TempNum := DecimalNumber                          ' Extract the least significant digit
      TempNum := DecimalNumber - ((TempNum / 10) * 10)

      Digit := "0" + TempNum                            ' Display the least significant digit
      gr.text(x,y,@Digit)

      x -= 8
      DecimalIndex := DecimalIndex + 1
      DecimalNumber := DecimalNumber / 10               ' Divide DecimalNumber by 10 

      if DecimalNumber == 0                             'Exit logic
         repeat while DecimalIndex < DecimalPoint       '   Do this if DecimalNumber is less than where the decimal point should be
            gr.text(x,y,@Zero)
            x -= 8
            DecimalIndex := DecimalIndex + 1
            DecimalFlag := 1
         if DecimalPoint > 0
            if DecimalIndex == DecimalPoint             '   Set flag if DecimalNumber is equal to where the decimal point should be  
               DecimalFlag := 1   
         if DecimalFlag == 1
            gr.text(x,y,@DP)                            '   Insert decimal and leading Zero
            x -= 8
            gr.text(x,y,@Zero)                          
            x -= 8                
         if sign == 1                                   '   Restore sign of DecimalNumber
            gr.text(x,y,@Hyphen)
         quit

'PUB DEG2PROP(Deg)               'Convert Deg to 13-bit Propeller angle
'    Result := (Deg * 1024)/45

         
PUB Cos(angle)                  'Cos angle is 13-bit ; Returns a 16-bit signed value
    Result := sin(angle + $800)

PUB Sin(pangle) | q                  ' prop angle is 0 to 2^13 (0 to 8191) for 0 to 360 degrees
  q := pangle >> 11                  ' quadrant is 2 highest bits
  result := (pangle & $7ff) << 1     ' 0 to 90- degrees, 11 bits, times two for word offset into sine table
  case q                                  ' result by quadrant, lookup in HUB SINE table
    0 : result :=  word[$E000 + result]                     
    1 : result :=  word[$F000 - result]
    2 : result := -word[$E000 + result]
    3 : result := -word[$F000 - result]
  return
  
DAT

Zero                    word    "0"
DP                      word    "."
Hyphen                  word    "-"        
        